﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Drawing;



namespace IPBL
{
    public static class Editors
    {
        public static Bitmap blank(int w,int h)
        {
            Bitmap bmp = new Bitmap(w, h);
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                    bmp.SetPixel(i, j, Color.Black);
            return bmp;
        }
        public static Bitmap resize(ref Bitmap bmp, int newwidth, int newheight)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] image = Matris.Load.Matris3DFromeBMP_(ref bmp);
            //bmp.Dispose();

            double nwidth = Convert.ToDouble(newwidth), nheight = Convert.ToDouble(newheight);
            int[, ,] newimage = Matris.Edit.Resize(ref image, width, height, nwidth, nheight);

            //saving rezult
            int newWidth = Convert.ToInt32(nwidth), newHeight = Convert.ToInt32(nheight);
            return Matris.Load.BMPfromeMatris3D(ref newimage, newwidth, newheight);
        }
        public static Bitmap rotate(ref Bitmap bmp, string rotateType)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(height,width);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    switch (rotateType)
                    {
                        case "left":
                        case "90":
                            bmpnew.SetPixel(j,i , bmp.GetPixel(i, j));
                            break;
                        case "right":
                        case "-90":
                        case "270":
                            bmpnew.SetPixel(height - 1 - j, i, bmp.GetPixel(i, j));
                            break;
                    }
                }
            }

            return bmpnew;
        }
        public static Bitmap rotate(ref Bitmap image, double radius)
        {
            int width = image.Width, height = image.Height;

            radius = radius * Math.PI / 180;

            //calc new height
            double
                x1 = (-width / 2) * Math.Cos(radius) - (height / 2) * Math.Sin(radius),
                y1 = (-width / 2) * Math.Sin(radius) + (height / 2) * Math.Cos(radius),
                x2 = (width / 2) * Math.Cos(radius) - (height / 2) * Math.Sin(radius),
                y2 = (width / 2) * Math.Sin(radius) + (height / 2) * Math.Cos(radius),
                x3 = (width / 2) * Math.Cos(radius) - (-height / 2) * Math.Sin(radius),
                y3 = (width / 2) * Math.Sin(radius) + (-height / 2) * Math.Cos(radius),
                x4 = (-width / 2) * Math.Cos(radius) - (-height / 2) * Math.Sin(radius),
                y4 = (-width / 2) * Math.Sin(radius) + (-height / 2) * Math.Cos(radius);
            double
                maxx = Math.Max(x1, Math.Max(x2, Math.Max(x3, x4))),
                minx = Math.Min(x1, Math.Min(x2, Math.Min(x3, x4))),
                maxy = Math.Max(y1, Math.Max(y2, Math.Max(y3, y4))),
                miny = Math.Min(y1, Math.Min(y2, Math.Min(y3, y4)));
            int newwidth = Convert.ToInt32(maxx - minx), newheight = Convert.ToInt32(maxy - miny);
            Bitmap newimage = new Bitmap(newwidth, newheight);
            for (int i = 0; i < newwidth; i++) for (int j = 0; j < newheight; j++) newimage.SetPixel(i, j, Color.Black);

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int new_i = Convert.ToInt32(Math.Ceiling((i - width / 2) * Math.Cos(radius) - (j - height / 2) * Math.Sin(radius))) + (newwidth / 2);
                    new_i = new_i < 0 ? 0 : new_i >= newwidth ? newwidth - 1 : new_i;
                    int new_j = Convert.ToInt32(Math.Ceiling((i - width / 2) * Math.Sin(radius) + (j - height / 2) * Math.Cos(radius))) + (newheight / 2);
                    new_j = new_j < 0 ? 0 : new_j >= newheight ? newheight - 1 : new_j;

                    Color c = image.GetPixel(i, j);
                    newimage.SetPixel(new_i , new_j , c);
                }//j
            }//i

            return newimage;
        }
        public static Bitmap mirrore(ref Bitmap bmp, string mirroretype)
        {
            int width = bmp.Width, height = bmp.Height;
            Bitmap bmpnew = new Bitmap(width ,height);

            switch (mirroretype)
            {
                case "vert":
                case "vertical":
                    for (int i = 0; i < width; i++)
                        for (int j = 1; j <= height; j++)
                            bmpnew.SetPixel(i, height - j, bmp.GetPixel(i, j - 1));
                    break;
                case "horiz":
                case "horizontal":
                    for (int i = 1; i <= width; i++)
                        for (int j = 0; j < height; j++)
                            bmpnew.SetPixel(width - i, j, bmp.GetPixel(i - 1, j));
                    break;
            }
            return bmpnew;
        }
        public static Bitmap crop(ref Bitmap bmp, int sx, int sy, int ex, int ey)
        {
            int nwidth = ex - sx, nheight = ey - sy;
            Bitmap bmpnew = new Bitmap(nwidth, nheight);

            for (int i = sx; i < ex; i++)
                for (int j = sy; j < ey; j++)
                    bmpnew.SetPixel(i - sx, j - sy, bmp.GetPixel(i, j));

            return bmpnew;
        }
        public static Bitmap past(Bitmap bmp1,Bitmap bmp2, string type,int sx,int sy)
        {
            int width1 = bmp1.Width, height1 = bmp1.Height;
            int width2 = bmp2.Width, height2 = bmp2.Height;

            Bitmap bmpnew = new Bitmap(width1, height1);
            for (int i = 0; i < width1; i++)
                for (int j = 0; j < height1; j++)
                    bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));

            int endw = width1 < (width2 + sx) ? width1 : width2 + sx;
            int endh = height1 < (height2 + sy) ? height1 : height2 + sy;
            for (int i = sx; i < endw; i++)
            {
                for (int j = sy; j < endh; j++)
                {
                    Color c = bmp2.GetPixel(i - sx, j - sy);
                    switch (type)
                    {
                        case "transpw":
                        case "transaprentwhite":
                            //if (c == Color.White)
                            if (c.R == 255 && c.G == 255 && c.B == 255)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                            else
                                bmpnew.SetPixel(i, j, bmp2.GetPixel(i - sx, j - sy));
                            break;
                        case "transpb":
                        case "transparentblack":
                            //if (c == Color.Black)
                            if (c.R == 0 && c.G == 0 && c.B == 0)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                            else
                                bmpnew.SetPixel(i, j, bmp2.GetPixel(i - sx, j - sy));
                            break;
                        case "":
                            bmpnew.SetPixel(i, j, bmp2.GetPixel(i - sx, j - sy));
                            break;
                    }
                }
            }

            return bmpnew;
        }
        public static Bitmap past(ref Bitmap bmp1, ref Bitmap bmp2, string type, int sx, int sy)
        {
            int width1 = bmp1.Width, height1 = bmp1.Height;
            int width2 = bmp2.Width, height2 = bmp2.Height;

            Bitmap bmpnew = new Bitmap(bmp1);

            int newbmp_sx = sx < 0 ? 0 : sx > bmp1.Width - 1 ? bmp1.Width - 1 : sx;
            int newbmp_sy = sy < 0 ? 0 : sy > bmp1.Height - 1 ? bmp1.Height - 1 : sy;
            int endw = width1 < (width2 + sx) ? width1 : width2 + sx;
            int endh = height1 < (height2 + sy) ? height1 : height2 + sy;

            for (int i = newbmp_sx; i < endw; i++)
            {
                for (int j = newbmp_sy; j < endh; j++)
                {
                    Color c = bmp2.GetPixel(i - sx, j - sy);
                    switch (type)
                    {
                        case "transpw":
                        case "transaprentwhite":
                            //if (c == Color.White)
                            if (c.R == 255 && c.G == 255 && c.B == 255)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                            else
                                bmpnew.SetPixel(i, j, c);
                            break;
                        case "transpb":
                        case "transparentblack":
                            //if (c == Color.Black)
                            if (c.R == 0 && c.G == 0 && c.B == 0)
                                bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));
                            else
                                bmpnew.SetPixel(i, j, c);
                            break;
                        case "":
                            bmpnew.SetPixel(i, j, c);
                            break;
                    }
                }
            }

            return bmpnew;
        }
        /// <summary>
        /// نشان میدهد آیا یک تصویر کادری به اندازه خاص دارد یا خیر
        /// </summary>
        public static bool hasbeenExpanded(ref Bitmap bmp, int cadrSize)
        {
            int width = bmp.Width, height = bmp.Height;
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref bmp);
            //
            int cadrColor = imagematris[0, 0];
            //check up
            for (int i = 0; i < width; i++) for (int j = 0; j < cadrSize; j++) if (imagematris[i, j] != cadrColor) return false;
            //check right
            for (int j = 0; j < height; j++) for (int i = width - cadrSize; i < width; i++) if (imagematris[i, j] != cadrColor) return false;
            //check buttom
            for (int i = 0; i < width; i++) for (int j = height-cadrSize; j < height; j++) if (imagematris[i, j] != cadrColor) return false;
            //check left
            for (int j = 0; j < height; j++) for (int i = 0; i < cadrSize; i++) if (imagematris[i, j] != cadrColor) return false;
            return true;
        }
        public static Bitmap expand(ref Bitmap bmp, int newwidth,int newheight)
        {
            int width = bmp.Width, height = bmp.Height;

            if (newwidth <= width)
                return null;
            if (newheight <= height)
                return null;

            int paddingW = (newwidth-width)/2-1,paddingH=(newheight-height)/2-1;

            Bitmap blank_ = blank(newwidth, newheight);
            Bitmap newimage = past(blank_, bmp, "", paddingW, paddingH);

            return newimage;
        }
        public static Bitmap RemoveBlankCadr(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);


            int w = image.Width, h = image.Height;

            //finding non-blank space in image
            int firstCol = 0;
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) if (imagematris[i, j] != 0) { firstCol = i; i = w; break; }
            int lastCol = w;
            for (int i = w - 1; i >= 0; i--) for (int j = 0; j < h; j++) if (imagematris[i, j] != 0) { lastCol = i; i = 0; break; }
            int firstrow = 0;
            for (int i = 0; i < h; i++) for (int j = 0; j < w; j++) if (imagematris[j, i] != 0) { firstrow = i; i = h; break; }
            int lastRow = h;
            for (int i = h - 1; i >= 0; i--) for (int j = 0; j < w; j++) if (imagematris[j, i] != 0) { lastRow = i; i = 0; break; }

            //creating new image
            Bitmap bmpnew = crop(ref image, firstCol, firstrow, lastCol, lastRow);

            image.Dispose();

            return bmpnew;
        }//remove blanks
        public static Bitmap Centeralize(ref Bitmap image)
        {
            int[,] imagematris = Matris.Load.Matris2DFromeBMP(ref image);

            int w = image.Width, h = image.Height;

            //finding non-blank space in image
            int firstCol = 0;
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) if (imagematris[i, j] != 0) { firstCol = i; i = w; break; }
            int lastCol = w;
            for (int i = w - 1; i >= 0; i--) for (int j = 0; j < h; j++) if (imagematris[i, j] != 0) { lastCol = i; i = 0; break; }
            int firstRow = 0;
            for (int i = 0; i < h; i++) for (int j = 0; j < w; j++) if (imagematris[j, i] != 0) { firstRow = i; i = h; break; }
            int lastRow = h;
            for (int i = h - 1; i >= 0; i--) for (int j = 0; j < w; j++) if (imagematris[j, i] != 0) { lastRow = i; i = 0; break; }

            int StartW = (w - (lastCol - firstCol)) / 2;
            int deltaW = StartW - firstCol;
            int startH = (h - (lastRow - firstRow)) / 2;
            int deltaH = startH - firstRow;

            //creating new image
            Bitmap bmpnew = blank(w, h);
            //why i used { i <= lastCol + 1 } ? because i didnt use :{ MATH.CEIL() }
            for (int i = firstCol; i <= lastCol + 1; i++)
            {
                for (int j = firstRow; j <= lastRow + 1; j++)
                {
                    bmpnew.SetPixel(
                        i + deltaW, j + deltaH,
                        imagematris[i, j] == 1 ? Color.White : Color.Black);
                }
            }

            image.Dispose();

            return bmpnew;
        }//centeralize

        public static Bitmap MSPinsert(ref Bitmap bmp1, ref Bitmap bmp2, ref bool imageinserted)
        {
            int width1 = bmp1.Width, height1 = bmp1.Height;
            int width2 = bmp2.Width, height2 = bmp2.Height;

            if (width2 > width1 || height2 > height1)
                throw new Exception("ERRORE : seccond file size must be shorter than the first!");

            Bitmap bmpnew = new Bitmap(width1, height1);
            for (int i = 0; i < width1; i++)
                for (int j = 0; j < height1; j++)
                    bmpnew.SetPixel(i, j, bmp1.GetPixel(i, j));

            imageinserted = false;
            int alighn = 5;
            int Wsearch = width2 - 1 + (2 * alighn), Hsearch = height2 - 1 + (2 * alighn);
            for (int i = 0; i < width1-alighn; i++)
            {
                for (int j = 0; j < height1-alighn; j++) 
                {
                    Color c = bmp1.GetPixel(i, j);
                    if ((c.R == 0 && c.G == 0 && c.B == 0) &&
                        i < width1 - 1 - (2 * alighn) - width2 &&
                        j < height1 - 1 - (2 * alighn) - height2)
                    {
                        bool thisplaceisgood = true;
                        double endm = i + Wsearch, endn = j + Hsearch;
                        double incm = width2 > height2 ? 1 : Convert.ToDouble(width2) / Convert.ToDouble(height2);
                        double incn = height2 > width2 ? 1 : Convert.ToDouble(height2) / Convert.ToDouble(width2);
                        for (double m = i; m < endm; m+=incm)
                        {
                            for (double n = j; n < endn; n += incn)
                            {
                                Color cmn = bmp1.GetPixel(Convert.ToInt16(m), Convert.ToInt16(n));
                                //if (cmn.R == 0 && cmn.G == 0 && cmn.B == 0) ;
                                //donothing
                                //else
                                if (!(cmn.R == 0 && cmn.G == 0 && cmn.B == 0))
                                {
                                    m = i + Wsearch;
                                    thisplaceisgood = false;
                                    break;
                                }
                            }
                        }

                        //inserting image : filename2
                        if (thisplaceisgood == true)
                        {
                            int sw = i + alighn, ew = i + width2, sh = j + alighn, eh = j + height2;
                            for (int m = sw; m < ew; m++)
                                for (int n = sh; n < eh; n++)
                                    bmpnew.SetPixel(m, n, bmp2.GetPixel(m - sw, n - sh));
                            //exiting
                            imageinserted = true;
                            i = width1; j = height1; break;
                        }//inserting image
                    }//if black and in cadr
                }//i
            }//j

            if (imageinserted == true)
                return bmpnew;
            else
                throw new Exception("ERRORE : blank space not enough to insert new image ,or no blank space founded!");
        }

        public static void MSPExtractSubPictures(
            ref Bitmap image,   string filename,
            int WstartOfset,    int HstartOffset,
            int Wlength,        int Hlength,
            int Woffsets,       int Hoffsets)
        {
            int w = image.Width, h = image.Height;

            int imscnt = 1;

            for (int i = WstartOfset; i < w; i += Wlength + Woffsets)
            {
                for (int j = HstartOffset; j < h; j += Hlength + Hoffsets)
                {
                    if (i + Wlength >= w) break;
                    if (j + Hlength >= h) break;

                    Bitmap tmpbmp = new Bitmap(Wlength, Hlength);
                    tmpbmp = crop(ref image, i, j, i + Wlength, j + Hlength);
                    tmpbmp.Save(filename.Replace(".bmp", "_" + imscnt.ToString() + ".bmp"));
                    tmpbmp.Dispose();

                    imscnt++;
                }
            }

            image.Dispose();
        }

    }//clas EDITROS

}//name space imageprocessingcommandline

